#include <stdlib.h>
#include <stdio.h>

#include "test_utils.h"

int **allocate_matrix(int r, int c)
{
    int **mat = malloc(r * sizeof(int *));
    for (int i = 0; i < r; i++)
    {
        mat[i] = malloc(c * sizeof(int));
    }
    return mat;
}

void free_matrix(int **mat, int r)
{
    for (int i = 0; i < r; i++)
    {
        free(mat[i]);
    }
    free(mat);
}

void display_matrix(int **mat, int r, int c)
{
    printf("----\n");
    for (int i = 0; i < r; i++)
    {
        for (int j = 0; j < c; j++)
        {
            printf("%2d ", mat[i][j]);
        }
        printf("\n");
    }
}

void display_piece(const struct piece *target)
{
    printf("Piece:\n");
    display_matrix(target->shape, target->size, target->size);
}

void display_board(const struct board* target)
{
    printf("Board:\n");
    display_matrix(target->data, target->n_rows, target->n_cols);
}

struct piece clone_piece(const struct piece *piece)
{
    struct piece new_piece;

    new_piece.size = piece->size;
    new_piece.shape = allocate_matrix(piece->size, piece->size);
    for (int i = 0; i < new_piece.size; i++)
    {
        for (int j = 0; j < new_piece.size; j++)
        {
            new_piece.shape[i][j] = piece->shape[i][j];
        }
    }
    return new_piece;
}

struct piece piece_from_array(const int *mat, int size)
{
    struct piece new_piece;

    new_piece.size = size;
    new_piece.shape = allocate_matrix(size, size);
    for (int i = 0; i < size; i++)
    {
        for (int j = 0; j < size; j++)
        {
            new_piece.shape[i][j] = mat[size * i + j];
        }
    }

    return new_piece;
}

struct board board_from_array(const int *mat, int n_rows, int n_cols)
{
    struct board new_board;

    new_board.n_rows = n_rows;
    new_board.n_cols = n_cols;
    new_board.data = allocate_matrix(n_rows, n_cols);
    for (int i = 0; i < n_rows; i++)
    {
        for (int j = 0; j < n_cols; j++)
        {
            new_board.data[i][j] = mat[n_cols * i + j];
        }
    }

    return new_board;
}

int piece_equals(const struct piece *piece1, const struct piece *piece2)
{
    if (piece1->size != piece2->size)
    {
        return 0;
    }

    for (int i = 0; i < piece1->size; i++)
    {
        for (int j = 0; j < piece1->size; j++)
        {
            if (piece1->shape[i][j] != piece2->shape[i][j])
            {
                return 0;
            }
        }
    }
    return 1;
}

void free_piece(struct piece *target)
{
    free_matrix(target->shape, target->size);
}

void free_board(struct board *target)
{
    free_matrix(target->data, target->n_rows);
}

struct piece piece_from_stdin()
{
    struct piece target;
    scanf("%d", &target.size);
    target.shape = allocate_matrix(target.size, target.size);
    for (int i = 0; i < target.size; i++)
    {
        for (int j = 0; j < target.size; j++)
        {
            scanf("%d", &target.shape[i][j]);
        }
    }
    return target;
}

struct board board_from_stdin()
{
    struct board target;

    scanf("%d %d", &target.n_rows, &target.n_cols);
    target.data = allocate_matrix(target.n_rows, target.n_cols);
    for (int i = 0; i < target.n_rows; i++)
    {
        for (int j = 0; j < target.n_cols; j++)
        {
            scanf("%d", &target.data[i][j]);
        }
    }

    return target;
}
