#include <stdio.h>
#include <stdlib.h>

#include "test_utils.h"
#include "engine.h"

int main()
{
    int right_L_shape[3][3] = {
        {0, 1, 0},
        {0, 1, 0},
        {0, 1, 1},
    };
    struct piece right_L = piece_from_array(right_L_shape[0], 3);

    int expected_rotation[3][3] = {
        {0, 0, 0},
        {1, 1, 1},
        {1, 0, 0},
    };
    struct piece expected_rotated_right_L = piece_from_array(expected_rotation[0], 3);

    printf("Let's rotate an L piece:\n");
    display_piece(&right_L);

    struct piece rot_piece = clone_piece(&right_L);
    // Test rotation;
    // The function needs an already allocated piece,
    // so we pass it a clone of right_l_piece as 2nd parameter
    rotate_piece(&right_L, &rot_piece);

    if (!piece_equals(&rot_piece, &expected_rotated_right_L))
    {
        // The outcome of the rotation does not match the expected value
        printf("❌ Rotation test failed\n");
        printf("Here is the bad outcome:\n");
        display_piece(&rot_piece);
        printf("---\n");
    }
    else
    {
        // The outcome of the rotation is just right
        printf("✅ Rotation test succeeded!\n");
        printf("We got the following rotated piece:\n");
        display_piece(&rot_piece);
        printf("---\n");
    }

    int T_shape[3][3] = {
        {0, 0, 0},
        {1, 1, 1},
        {0, 1, 0},
    };
    struct piece T_vec[4] = {
        piece_from_array(T_shape[0], 3),
        piece_from_array(T_shape[0], 3),
        piece_from_array(T_shape[0], 3),
        piece_from_array(T_shape[0], 3),
    };

    for (int i = 1; i < 4; i++)
    {
        rotate_piece(&T_vec[i - 1], &T_vec[i]);
    }

    int test_board_data[8][6] = {
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0},
        {5, 0, 0, 0, 0, 0},
        {5, 2, 3, 3, 0, 0},
        {5, 2, 2, 0, 0, 0},
        {5, 2, 4, 0, 1, 1},
        {4, 4, 4, 0, 1, 1},
    };
    struct board test_board = board_from_array(test_board_data[0], 8, 6);

    printf("Here is a sample board:\n");
    display_board(&test_board);

    free_piece(&rot_piece);
    free_piece(&expected_rotated_right_L);
    free_piece(&right_L);
    for (int i = 0; i < 4; i++)
    {
        free_piece(&T_vec[i]);
    }
    free_board(&test_board);
}
