#include <iostream>
#include <vector>
#include <memory>


class Figure
{
public:
    Figure()
    {}

    virtual ~Figure()
    {}

    virtual void afficher(std::ostream& out) const = 0;

protected:
    Figure(const Figure& f)
    {}
};

class Rectangle : public Figure
{
public:
    Rectangle(double l, double h)
        :largeur(l), hauteur(h)
    {}

    void afficher(std::ostream& out) const
    {
        out << "rectangle : " << largeur << "x" << hauteur << std::endl;

    }
private:
    double largeur;
    double hauteur;
};


class Cercle : public Figure
{
public:
    Cercle(double r)
        :rayon(r)
    {}

    void afficher(std::ostream& out) const
    {
        out << "cercle de rayon " << rayon << std::endl;
    }

private:
    double rayon;
};

class Dessin
{

private:
    // pour le polymorphisme: on est obligé de travailler avec des
    // pointeurs sur Figure
    // on choisit des pointeurs unique car Dessin a la propriété
    // complètes de figures non partagées par d'autres parties de programme
    std::vector<std::unique_ptr<Figure>> desFigures;

public:

    void ajouterFigure(std::unique_ptr<Figure> figure)
    {
        // on déplace le pointeur passé en argument
        // vers la collection (pas de copie)
        desFigures.push_back(move(figure));
    }


    void afficher(std::ostream& out) const
    {
        for (const auto& figure : desFigures) {
            figure->afficher(out);
        }
    }

    // plus besoin de gérer explicitement la mémoire
};


int main()
{
    Dessin d;
    //on montre les pointeurs mais les pointeurs intelligent
    // indiquent clairement que
    // la propriété est transférée au dessin
    // (ce qui n'est pas le cas avec les pointeurs à la C)
    d.ajouterFigure(std::unique_ptr<Figure>(new Cercle(3.5)));
    d.ajouterFigure(std::unique_ptr<Figure>(new Rectangle(1.2,4.5)));
    d.afficher(std::cout);

    return 0;
}










