close all
clear all

% standard deviation
std1=1; std2=1; 
% mean
m1=4; m2=8; 
% mixture proportions 
pi1=0.3; 
pi2=1-pi1;


% number of samples
dataSize=1000;
% number of samples to display
displaySize=100;

% generate two vectors, one from the fisrt distribution and the other form the second
data1=m1+std1*randn(1,dataSize); 
data2=m2+std2*randn(1,dataSize);

% generate a selection vector (i.e., a sequence of coins)
selectionVariable=rand(1,dataSize);
class1=(selectionVariable<=pi1); 
class2=not(class1);

% construct the mixture data 
mixtureData=zeros(1,dataSize); 
mixtureData(class1)=data1(class1); 
mixtureData(class2)=data2(class2);

% now plot the data generated by each distribution and the mixture data
figure;

% distribution 1
h1=subplot(3,1,1); 
stairs(data1(1:displaySize)); 
title(['Data sampled from first distribution $\sigma_1=$ ' num2str(std1) ', $m_1=$ ' num2str(m1)])
ylabel('data1 '); 
xlabel('samples ');
makeItNicer
% distribution 2
h2=subplot(3,1,2); 
stairs(data2(1:displaySize)); 
title(['Data sampled from second distribution $\sigma_2=$ ' num2str(std2) ', $m_2=$ ' num2str(m2)])
ylabel('data2 '); 
xlabel('samples ');
makeItNicer
% mixture distribution
h3=subplot(3,1,3); 
stairs(mixtureData(1:displaySize)); 
title('Data sampled from the mixture distribution ')
ylabel('mixtureData ');
xlabel('samples ');
makeItNicer
% Set the axis 
maxY=max([data1 data2]); 
minY=min([data1 data2]); 
axis([h1 h2 h3],[0 displaySize minY maxY]);
% set color
temp=mixtureData(1:displaySize);
temp(class1(1:displaySize))=NaN;
hold on; subplot(3,1,3);
stairs(temp,'r');

function makeItNicer
    axisProperties=gca; % get the pointer to the axis properties 
    axisProperties.FontSize=18; % set the font size 
    axisProperties.Title.Interpreter='latex'; % set the text interpreter 
    axisProperties.YLabel.Interpreter='latex'; 
    axisProperties.XLabel.Interpreter='latex';
end






