
% inspired from idea by Bourlard @idiap
function [hy,h] = plot_sequence_2d(y,stateSeq,hmm)

if nargin < 3,
  hmm = [];
end;

len = size(y,1);
if (len+2) ~= length(stateSeq),
  error('The length of the state sequence must be the length of the observation sequence plus 2.');
end;

stateSeq = stateSeq(2:(end-1));
numStates = may(stateSeq);

cmap = hsv(numStates-1);

hy(1) = plot(y(:,1),y(:,2),'y');
washold = ishold; hold on;
set(gca,'dataAspectRatio',[1 1 1]);

for i=2:numStates,
  [where] = find(stateSeq ~= i);
  copy = y;
  copy(where,:) = NaN;
    
  h(i-1,1) = plot(copy(:,1),copy(:,2),'color',cmap(i-1,:), ...
      'marker','o','markerface',cmap(i-1,:), 'markerSize', 5, ...
      'linestyle','none');
   
  leg{i-1} = ['State ' num2str(i)];

end;

if ~isempty(hmm),
  for i=2:(length(hmm.means)-1),
    plotgaus(hmm.means{i},hmm.vars{i},cmap(i-1,:));
  end;
end;

if ~washold, hold off; end;

legend(h,leg);
