% inspired from idea by Bourlard @idiap

function [y,stateSeq] = generate_hmm(means,vars,transitions)

% You can feed the function a single struct representing an HMM parameters
% means vars and transitions

if nargin == 1
  model = means;
  means = model.means;
  vars = model.vars;
  transitions = model.trans;
end

dim = length(means{2});
numStates = length(means);

for i=2:(numStates-1)
  stDevs{i} = sqrtm(vars{i});
end
stDevs{1} = [];
stDevs{numStates} = [];

stateSeq(1) = 1; % Begin with entry state
t = 1;
while (stateSeq(t) ~= numStates)
  t = t+1;
  stateSeq(t) = pickState( transitions(stateSeq(t-1),:) );
end

for t = 2:(length(stateSeq)-1)
  y(t-1,:) = randn(1,dim) * stDevs{stateSeq(t)} + means{stateSeq(t)}';
end


%=============================================
function [stat] = pickState(localTransitions)

cs = cumsum(localTransitions);
if ( (cs(end) - 1.0) > (eps/2) )
  error('Bad transition probability');
end

unif = rand;
stat = 1;
while ( unif >= cs(stat) )
  stat = stat+1;
end
