
% inspired from idea by Bourlard @idiap
function logProb = forward_recursion(y,means,vars,transitions)


if nargin == 2
  model = means;
  means = model.means;
  vars = model.vars;
  model.trans(model.trans<1e-100) = 1e-100;
  logTrans = log(model.trans);
end

numStates = length(means);
nMinOne = numStates - 1;
[numPts,dim] = size(y);

log2pi = log(2*pi);
for i=2:nMinOne
  invSig{i} = inv(vars{i});
  logDetVars2(i) = - 0.5 * log(det(vars{i})) - log2pi;
end

for i=2:nMinOne
  Y = y(1,:)-means{i}';
  alpha(i) = logTrans(1,i) ...
      - 0.5 * (Y * invSig{i}) * Y' + logDetVars2(i);
end
alpha = alpha(:);

%  forward recursion
for t = 2:numPts
  alphaBefore = alpha;
  for i = 2:nMinOne
    Y = y(t,:)-means{i}';
    alpha(i) = logsum( alphaBefore(2:nMinOne) + logTrans(2:nMinOne,i) ) ...
	- 0.5 * (Y * invSig{i}) * Y' + logDetVars2(i);
  end
end

logProb =  logsum( alpha(2:nMinOne) + logTrans(2:nMinOne,numStates) );

function result = logsum(logv)

len = length(logv);
if (len<2)
  error('Subroutine logsum cannot sum less than 2 terms.');
end

if (logv(2)<logv(1))
  result = logv(1) + log( 1 + exp( logv(2)-logv(1) ) );
else
  result = logv(2) + log( 1 + exp( logv(1)-logv(2) ) );
end

for (i=3:len)
  term = logv(i);
  if (result<term)
    result = term   + log( 1 + exp( result-term ) );
  else
    result = result + log( 1 + exp( term-result ) );
  end 
end
