function [f] = esprit(x, fs, n)
m = 5*n+1; % ??

% empirical covariance
R=mycorr(x,m);

%eigen decomposition of empirical cov
[eigvec, eigval]=eig(R);

%Matlab doesn't sort the eigenvalues
[d, idx] = sort(diag(eigval),'descend');
eigval = eigval(idx,idx);
eigvec=eigvec(:,idx); 

S=eigvec(:,1:n); % m*n matrix
S1=S(1:m-1,:);  % (m-1)*n matrix
S2=S(2:m,:); % (m-1)*n matrix

phi=(S1'*S1)^(-1)*S1'*S2;
[eigvectphi, eigvalphi]=eig(phi);
[w,idx] = sort(diag(eigvalphi),'descend');

f=angle(w)*fs/(2*pi);
f=sort(abs(f));


end

