%% Non-adaptative optimal filter (Mobile Recording)
clc;
clear;

Nf=800;

[x, ~]=audioread('Sig.wav'); % Interfering Signal
[y, fs]=audioread('RecChanging.wav'); % Recorded Signal (Mobile recording)

RX=zeros(Nf,1);
RYX=zeros(Nf,1);

% Compute correlations
for i=1:Nf
    RX(i)=mean(x(1:end-Nf).*x(i:end+i-1-Nf));
    RYX(i)=mean(x(1:end-Nf).*y(i:end+i-1-Nf));
end

% Compute the correlation matrix
R=RX(1+abs(repmat((1:Nf),Nf,1)-repmat((1:Nf),Nf,1)'));

% Compute the NonAdaptative Optimal filter
f=R\RYX;

% Remove the interfering signal
yp=y-filter(f,1,x);

ypNANI_M=yp;

figure;
plot((1:Nf)/fs,f);
xlabel('Time [ms]');
ylabel('Amplitude');
title('Room Impluse Response NA-NI');

figure;
plot(y,'b');hold on; plot(yp,'r');
xlabel('Time [ms]');
ylabel('Amplitude');
title('Sound Wave NA-NI');
legend('Original','Filtered');

%% Adaptive filtering (LMS algorithm) (Mobile Recording)

yp=zeros(length(y),1);
mu=0.03;
fad=zeros(Nf,1);

Nit=20;

% Adaptive filtering
for i=Nf:length(y)
    X=x(i-Nf+1:i);
    for j=1:Nit
        fad=fad+mu*X*(y(i)-X'*fad);
    end
    yp(i)=y(i)-fad'*X;
    
    % Plot the adaptive filter at some instants
    if((mod(i-2*fs,5*fs)==0) && (i>10*fs))
        figure;
        plot((1:Nf)/fs,fad(end:-1:1));
        L=max(abs(f));
        ylim([-1.5*L 1.5*L]);
        xlabel('Time [ms]');
        ylabel('Amplitude');
        title(sprintf('Room Impluse Response at t=%d s',i/fs));
    end
end

ypAI_M=yp;

fad=fad(end:-1:1);

figure;
plot((1:Nf)/fs,f,'r'); hold on; plot((1:Nf)/fs,fad,'b');
xlabel('Time [ms]');
ylabel('Amplitude');
title('Room Impluse Response A');
legend('NonAdaptative Optimal Filter','Adaptive filter (last computed)');

figure;
plot(y,'b');hold on; plot(yp,'r');
xlabel('Time [ms]');
ylabel('Amplitude');
title('Sound Wave A');
legend('Original','Filtered');