% Problem 2

close all
clear all

% Load the various vectors
load preamble.mat
load rx_samples.mat

% Define parameters
SPS = 5; % Samples per symbol

% Find the start of the preamble within the received samples. If your code
% works properly, you should find that the preamble starts at the sample
% number 211.

% Create the pulse-shaped preamble
preamble_ps = kron(preamble, ones(1,SPS));
% Do the correlation
R = xcorr(rx_samples, preamble_ps);

% Plot to see what we have got
figure;
stem(abs(R));
grid on;
title('The result of the correlation');

% Remove ramp up and find the sample number where the preamble starts
R = R(length(rx_samples):end);
[~, ind] = max(abs(R))


% Extract from the received samples the portion corresponding to the 1000
% transmitted BPSK data symbols and process it accordingly in order to
% generate the sufficient statistics about the transmitted data symbols.
% Plot the result. If your code works properly, you should obtain a rotated
% (and noisy) BPSK constellation.

N = length(preamble);
load tx_data_symbols.mat
L = length(tx_data_symbols);
% Extract the useful samples corresponding to the transmitted BPSK symbols
rx_data_samples = rx_samples(ind + SPS*N:ind + SPS*(N+L) - 1);

% Implement the matched filter (MF)
rx_data_samples_mf = conv(rx_data_samples, ones(1, SPS));
% Remove the tails
rx_data_samples_mf = rx_data_samples_mf(SPS:end-SPS+1);
% Sample the MF output
suffStat = rx_data_samples_mf(1:SPS:end);
% Check the length
length_suffStat = length(suffStat)

% Plot the constellation
figure;
plot(suffStat, '*');
grid on; xlabel('Real'); ylabel('Imaginary');
title('The received constellation at the output of the matched filter');


% Perform differential decoding. Assume that the first symbol is either a
% +1 or a -1 and then decide on the following symbols depending on the
% phase difference between two consecutive values of the sampled output of
% the matched filter.

% Plot the phase difference to see what we have got
phase = angle(suffStat(1:end-1).*conj(suffStat(2:end)));

figure;
plot(phase, '*');
grid on;
title('Phase difference')

% Assume that the first symbol was an +1 and then perform differential
% decoding.
decodedSymbols = zeros(1,L);
decodedSymbols(1) = 1;
for k=1:length(phase)
    decodedSymbols(k+1) = (1 - 2*(abs(phase(k)) > pi/2))*decodedSymbols(k);
end


% At this point, using the transmitted data symbols given to you, one can
% compute the symbol error rate (SER). If your code works properly, this
% should be either 0, if your assumption about the first symbol was
% correct, or 1, if your assumption about the first symbol was wrong.

first_transmitted_symbol = tx_data_symbols(1)
first_decoded_symbol = decodedSymbols(1)
SER = sum(decodedSymbols ~= tx_data_symbols)/length(tx_data_symbols)
