import numpy as np
import matplotlib.pyplot as plt
import utilMidterm

# Problem 2

# Define parameters
N = int(1e3)  # number of symbols
beta = 0.22
SPAN = int(16)
SPS = int(50)
SNR_dB = 20  # dB
# T and Fs are needed for the eye diagram
T = 1  # s
Fs = SPS/T

# Create N BPSK symbols
symbols = 2*np.random.randint(2, size=N) - 1

# Map the symbols to samples using rcosdesign with the parameters above
h = utilMidterm.rcosdesign(beta, SPAN, SPS)
# the pulse is already normalized
symbols_up = np.kron(symbols, np.concatenate((np.ones(1), np.zeros(SPS-1))))
samples = np.convolve(symbols_up, h)

# Create and add complex-valued Gaussian noise such that the SNR at the
# output of the matched filter is SNR_dB
Es = np.var(symbols)
# find the noise variance sigma2 so that 10*log_10(Es/sigma2) = SNR_dB
sigma2 = Es/(10 ** (SNR_dB/10))
sigma = np.sqrt(sigma2)
# create the sample-level noise vector
noise = (sigma/np.sqrt(2))*np.random.randn(np.size(samples)) + 1j*(sigma/np.sqrt(2))*np.random.randn(np.size(samples))
actual_SNR = 10*np.log10(np.var(symbols)/np.var(noise))
print('The obtained SNR is: %s [dB]', actual_SNR)  # test that we get back SNR
# create the channel output
received = samples + noise

# Generate the output of the matched filter and the sufficient statistics
h_matched = np.conj(np.flip(h))
# the matched filter output before downsampling is
mfOutput = np.convolve(received, h_matched)
# remove the tails
mfOutput = mfOutput[np.size(h_matched)-1:-np.size(h_matched) + 1]
# downsample
suffStat = mfOutput[0:mfOutput.size:SPS]

# Plot the eye diagram

# cast y to real, as it should be
y = mfOutput.real

time = np.arange(0, 2*T, 1/Fs) - T

# remove extra samples (if any)
y = y[0: y.size - (y.size % time.size)]
y = np.reshape(y, (time.size, int(y.size/time.size)), 'F')

plt.plot(time, y)
plt.ylabel('Amplitude')
plt.xlabel('Time [s]')
plt.title('Eye Diagram')
plt.grid()
plt.show()

# Plot the received constellation
plt.scatter(suffStat.real, suffStat.imag, marker='*')
plt.ylabel('Imaginary')
plt.xlabel('Real')
plt.title('Received constellation at the output of the MF')
plt.grid()
plt.show()

# Decode the symbols and check if there are any symbol errors
decodedSymbols = 2*(suffStat > 0) - 1
symbolErrorCount = np.sum(decodedSymbols != symbols)
print('symbolErrorCount = ', symbolErrorCount)
