% Problem 2

close all;
clear all;

% Define parameters
N = 1e3; % number of symbols
beta = 0.22;
SPAN = 16;
SPS = 50;
SNR_dB = 20; % dB
% T and Fs are needed for the eye diagram
T = 1; % s
Fs = SPS/T;


% Create N BPSK symbols 
symbols = 2*randi([0, 1],1,N) - 1;


% Map the symbols to samples using rcosdesign with the parameters above
h = rcosdesign(beta,SPAN,SPS);
% the pulse is already normalized
samples = conv(upsample(symbols, SPS),h);


% Create and add complex-valued Gaussian noise such that the SNR at the
% output of the matched filter is SNR_dB
Es = var(symbols);
% find the noise variance sigma2 so that 10*log_10(Es/sigma2) = SNR_dB
sigma2 = Es/(10^(SNR_dB/10));
sigma = sqrt(sigma2);
% create the sample-level noise vector
noise = (sigma/sqrt(2))*randn(size(samples)) + 1i*(sigma/sqrt(2))*randn(size(samples));
% the_SNR_in_dB_is = 10*log10(var(symbols)/var(noise)) % test that we get back SNR
% create the channel output
received = samples + noise;


% Generate the output of the matched filter and the sufficient statistics
h_matched = conj(fliplr(h));
% the matched filter output before downsampling is
mfOutput = conv(received, h_matched);
% remove the tails
mfOutput = mfOutput(length(h_matched):end-length(h_matched)+1);
% downsample 
suffStat = mfOutput(1:SPS:end);


% Plot the eye diagram
% make everything to column vectors
y    = mfOutput(:);
time = [0:1/Fs:2*T-1/Fs]'-T;
% remove extra samples (if any)
y    = y(1:length(y)-mod(length(y),length(time)));
y    = reshape(y,length(time),[]);

plot(time,real(y));
xlabel('Time [s]');
ylabel('Amplitude');
title('Eye Diagram');
grid  on;


% Plot the received constellation
figure;
plot(suffStat,'*'); grid on;
xlabel('Real'); ylabel('Imag'); title('Received constelation at the output of the MF');


% Decode the symbols and check if there are any symbol errors
decodedSymbols = 2*(suffStat > 0) - 1;
symbolErrorCount = sum(decodedSymbols(:) ~= symbols(:))


