% Problem 3

close all;
clear all;

% Load the received signal and the C/A code
load rx_signal_gps.mat
load ca_code.mat


% In the following we ask you to implement a matched filter receiver. The
% matched filter is matched to the pulse shape used by the satellite.
% Please follow strictly the instructions given below.

% Specify the matched filter
h_mf = fliplr(ca_code);
    

% Pass the received signal through the matched filter
y = conv(rx_signal_gps, h_mf);
    

% Plot the eye diagram at the output of the matched filter
y = y(1:end-mod(length(y),2*length(ca_code)));
ye = reshape(y,2*length(ca_code),[]);
xe = (1:1:2*length(ca_code))';

figure;
plot(xe, ye,'-*'); grid on;
title('The eye diagram at the output of the matched filter');
    

% Write a code that estimates the delay of the channel, based on the eye
% diagram. For simplicity, you can assume that the eye diagram is
% symmetrical with respect to the horizontal axis.
[min_over_rows, ~] = min(abs(ye),[],2);
[~, indexMax] = max(min_over_rows)
    

% Once you find the estimate of the delay, use it to downsample the matched
% filter output to generate the sufficient statistics
y_down = y(indexMax:length(ca_code):end);

figure;
plot(y_down,'*'); grid on;
title('The sufficient statistics');

% Use the sufficient statistics to estimate the bits transmitted by the
% satellite.
estimated_bits = 2*double(y_down>0)-1;
    

% If everything you did above was correct, you should obtain the bits
% stored in transmitted_bits.mat
load transmitted_bits.mat
number_of_errors = nnz(estimated_bits - transmitted_bits)



