% Problem 2

close all;
clear all;

% Load the received signal and the preamble
load rx_signal.mat
load preamble.mat

% Define parameters
SPS = 5; % samples per symbol
Ts = 10^-5; % sampling time [seconds]

% In the following, you will search for the Doppler frequency in the range
% [-500, 500] Hz with a Doppler step to be chosen as detailed below. While
% searching for the Doppler, you should also find the sample index
% corresponding to the start of the preamble.

% Compute the Doppler step such that, after correcting with the tentative
% Doppler frequency which is the closest to the true one, the residual
% phase over the duration of the preamble is less than pi/10 radians.
% Remember that in the following you should work with the preamble at the
% sample level (as opposed to symbol level).

% create the preamble samples
preamble_samples = kron(preamble, ones(1,SPS));
    
% 2*pi*doppler_step*length(preamble_samples)*Ts = pi/10
doppler_step = (2*10*length(preamble_samples)*Ts)^-1
    
    
% Search and find the Doppler and the beginning of the preamble.
% Check point: you should find a Doppler around 380 Hz, and the beginning
% of the preamble at sample 96.

dopplerRange = -500:doppler_step:500;
t = (0:1:length(rx_signal)-1)*Ts;

tau = -inf;
IP = -inf;
doppler_est = -inf;

for k = 1:length(dopplerRange)
    
    currentDoppler = dopplerRange(k);
    rx_signal_corrected = rx_signal.*exp(-1j*2*pi*currentDoppler*t);
    R = xcorr(rx_signal_corrected, preamble_samples);
    % remove the ramp-up and ramp-down
    R = R(length(rx_signal_corrected):end-length(preamble_samples)+1);
    [Rmax, index] = max(abs(R));
    
    if Rmax > IP
       tau = index;
       IP = Rmax;
       doppler_est = currentDoppler;
       Rs = R; % for plotting
    end
    
end

foundTau = tau
foundDoppler = doppler_est

figure;
stem(abs(Rs),'*'); grid on;
title('Correlation result for the found doppler and tau');

% Correct the whole received signal for the Doppler
rx_signal_corrected = rx_signal.*exp(-1j*2*pi*doppler_est*t);
    

% Plot (scatterplot) the received preamble (extracted from the corrected
% data above)
preamble_corrected = rx_signal_corrected(tau:tau+length(preamble_samples)-1);
figure;
plot(real(preamble_corrected), imag(preamble_corrected),'*');
grid on; xlabel('Real'); ylabel('Imag');
title('The received preamble (corrected for Doppler)');


% At this point, the received samples are affected only by a rotation with
% a fixed phase (and AWGN).
% Determine this phase. To do so, you should compare the received preamble
% (corrected for Doppler) with the transmitted one. If you do a
% component-wise comparison, your estimation can be made more robust.
% Check point: you should find a phase around 2 radians.

phase_vector = angle(preamble_corrected./preamble_samples);
figure;
plot(phase_vector,'-*'); grid on;
title('The Estimated Rotation (over the whole preamble)')
phase_est = mean(phase_vector)
    

% Correct the received preamble with the phase obtained above, downsample
% and plot the result (scatterplot).
% If everything you did above was correct, at this point you should see a
% noisy complex-valued BPSK constellation.
preamble_corrected_rotated = preamble_corrected*exp(-1j*phase_est);
preamble_downsampled = preamble_corrected_rotated(1:SPS:end);

figure;
plot(real(preamble_downsampled), imag(preamble_downsampled),'*');
grid on; title('Preamble corrected for Doppler and rotation, downsampled');


