import numpy as np
import scipy.io as sio

# Problem 2

# Load the received signal and the preamble
rx = sio.loadmat('rx_signal.mat')
rx_signal = rx['rx_signal'].flatten()
               
pr = sio.loadmat('preamble.mat')
preamble = pr['preamble'].flatten()

# Define parameters
SPS = 5  # samples per symbol
Ts = 1e-5  # sampling time [seconds]

# In the following, you will search for the Doppler frequency in the range
# [-500, 500] Hz with a Doppler step to be chosen as detailed below. While
# searching for the Doppler, you should also find the sample index
# corresponding to the start of the preamble.

# Compute the Doppler step such that, after correcting with the tentative
# Doppler frequency which is the closest to the true one, the residual
# phase over the duration of the preamble is less than pi/10 radians.
# Remember that in the following you should work with the preamble at the
# sample level (as opposed to symbol level).
...
doppler_step = ...
    
    
# Search and find the Doppler and the beginning of the preamble.
# Check point: you should find a Doppler around 380 Hz, and the beginning
# of the preamble at sample 96.
...
    

# Correct the whole received signal for the Doppler
...
    

# Plot (scatterplot) the received preamble (extracted from the corrected
# signal above)
...
    

# At this point, the received samples are affected only by a rotation with
# a fixed phase (and AWGN).
# Determine this phase. To do so, you should compare the received preamble
# (corrected for Doppler) with the transmitted one. If you do a
# component-wise comparison, your estimation can be made more robust.
# Check point: you should find a phase around 2 radians.
...
    

# Correct the received preamble with the phase obtained above, downsample
# and plot the result (scatterplot).
# If everything you did above was correct, at this point you should see a
# noisy complex-valued BPSK constellation.
...
    


