% compare the performance of 2 pulse shaping waveforms

close all;
clear all;

noSymbols = 1e3; % number of BPSK symbols
Es = 50; % energy per BPSK symbol
sigma2 = 2; % noise variance at the output of the matched filter

fs = 1e6; % sampling frequency in Hz

load psi1.mat
load psi2.mat


% Using the function tfplot, plot the two pulse shaping functions in
% time/frequency domain.
tfplot(psi1, fs, 'psi1','pulse 1')
tfplot(psi2, fs, 'psi2','pulse 2')

% Generate noSymbols BPSK symbols, with symbol energy Es
symbols = randi([0,1],[1 noSymbols]);
symbols = sqrt(Es)*(1-2*symbols);
 
% psi1 and psi2 are Nyquist pulses if shifted by the correct amount (same
% for both). Generate the two bit-by-bit on a pulse train signals using
% psi1 and psi2, respectively 
 
s1 =  conv(upsample(symbols,length(psi1)),psi1);
s2 =  conv(upsample(symbols,length(psi2)),psi2);

% Generate the noise signal (real valued and of the same length as s1 and
% s2) such that the noise variance at the output of an hypothetical matched
% filter is sigma2

noise = sqrt(sigma2)*randn(size(s1));

% Add the noise to the two transmitted signals
r1 = s1 + noise;
r2 = s2 + noise;


% Plot r1 and r2 in time/frequency domain. 
% Looking at the frequency domain plots, 
% you should notice that the signal r2 has completely disappeared in the noise, 
% while r1 is still visible.
tfplot(r1, fs, 'r1','Received Signal 1')
tfplot(r2, fs, 'r2','Received Signal 2')


% Let SER1 and SER2 be the symbol error probabilities corresponding to the
% case when using psi1 and psi2, respectively. (No need to simulate them.)
% For an arbitrary SNR, which of the following is true: 
% a) SER1 < SER2; 
% b) SER1 = SER2; 
% c) SER1 > SER2 
% d) It depends on the SNR
% Justify your answer. 

% The correct answer is b) since we are using the same symbol constellation
% and the noise variance is the same in both cases. The shape of the pulse
% is irrelevant, as long as they are Nyquist pulses, which is the case
% here. 
