
% p3
% delay and Doppler estimate


close all;
clear all;

%% parameter
fs = 1e6; % sampling frequency

%% create a random sequence of 100 bits taking values on {-1,+1}
nBits = 100;
% bits = ;

%% create a root raised cosine pulse h of beta=0.5, sps = 100, and span = 5
beta = 0.5;
sps = 100;
span = 5;
% h = rcosdesign(...);

%% use "bits" and "h" to create a bit-by-bit on a pulse train signal called s
%s = ;

%% the channel parameters
%%% Nota Bene: you can play with the following channel parameters ...
%%% but your final sulution cannot make use of them
fd = 100; % Hz
delay = 50; % samples
sigma2 = 0.5; % noise variance

%% the channel
%%% It delays, frequency shifts, and adds noise
%%% If curious about the details, the function is defined at the bottom
r = DelAndDop(s,sigma2,delay,fd,fs); % returned signal

%% estimate the delay and doppler, searching the doppler in [-200:1:200]

%%% ... Here goes the main part. Call the estimates delayEst and doppEst
%%% respectively

 
%%
function r = DelAndDop(s,sigma2,delay,fd,fs)
% r is a noisy, delayed, and frequency-shifted copy of s
% sigma2 is the desired variance of the added WGN (complex-valued)
% fd is the desired doppler frequency
% fs is the sampling rate 

l = length(s);
time = [0:l-1]/fs;
carrier = exp(1i*2*pi*fd*time);
sWithDoppler = s.*carrier;
% add zeros in front and in the back
tail = 200; % number of zeros in the back
sWithDopplerAndDelay = [zeros(1,delay),sWithDoppler,zeros(1,tail)];
% add noise
lW = length(sWithDopplerAndDelay);
r = sWithDopplerAndDelay + sqrt(sigma2/2)*randn(1,lW) + 1i*sqrt(sigma2/2)*randn(1,lW);
end

