% demodulate an AM signal

close all;
clear all;

% s.mat contains the samples of an AM signal. The AM signal is sampled at
% frequency fs, and the carrier frequency is fc.
load s.mat
fs = 1e4; % Hz
fc = 210; % Hz
l = length(s);

% you may want to plot s to see that it is an AM signal
% ....

% create a local carrier, not yet sychronized
timeline = 0:1/fs:(l-1)/fs;
unCarrier = cos(2*pi*fc*timeline); % unsynchronized carrier

% find out by how much you have to shift the local carrier so that 
% it is in phase with the carrier of the received signal
x = xcorr(s,unCarrier);
% ....

% create a new carrier that lines up with the carrier in s
% ....
% synchedCarrier = ....

% you may want to plot the synchedCarrier and verify that it lines up
% correctly.
% ....
 
% Optional bonus points: if you get stuck at the other problems, you can come 
% back here and get some extra points by continuing below this line. 
% The purpose is to demodulate the AM signal. 

y = s .* synchedCarrier;
 
% low-pass filter y (e.g. via Butterworth filter of order 2) using cutoff frequency fc/10
% ....

% remove the mean from the resulting signal.
% ....

% check: at this point you should have the demodulated signal (the envelope of the
% AM signal). (Don't worry about the initial transient). 
% ....