% interpolation

clear all; 
close all;

% a random pulse p
p = [9    10     2    10     7     1     3     6    10    10];
L = length(p);

k = 20; % upsampling factor
a = upsample(p,k);
b = sinc((-L*k+1:L*k-1)/k); % not the shortest length. 
% see the solution for the shortest length of b.

y = conv(a,b);

% uncomment and fill in the following lines when answering question 4
ind = L*k; % length of  the sinc's tail plus 1
t = 0:1:L*k-1; %  time axis for q
figure;
plot(t,y(ind+t),'r',t(1:k:L*k),p,'*');
grid on; legend('Interpolated', 'Original');