function estim_tx_bits  = my_demapper(r,mapping)

%% Make sure r is a vector
[nrows, ncols] = size(r);
if ((nrows ~= 1) && (ncols ~= 1))
	error('my_demodulator:inputNotVector', 'The input must be a vector');
end

% If y is a column vector, transpose it to make sure r is a row vector
if (nrows ~= 1)
	r = transpose(r); 
end	

M=length(mapping);

% Compute all Euclidean distances
num_symbols = length(r);
distances = abs(repmat(r, M, 1) - repmat(transpose(mapping), 1, num_symbols)); 

% find the minimum of every column of this matrix
[~, positions] = min(distances);

% The second output argument of min returns the row number for which the minimum was found in each column
estim_symbols = positions - 1; % Go from [1, M] indices to [0, M-1] M-ary symbols

% convert the int to bits
estim_tx_bits = de2bi(estim_symbols);
