clear all; close all; clc;

% police siren frequency
f=1000;

% speed of sound
c=343; %m/s

% relative speed 
vr=15;



% received signal
Fs=1e4;
Nfft=2048;

t=0:1/Fs:2;

s=sin(2*pi*f*(1+vr/c)*t);
sr=awgn(s,3,'measured');

save siren sr

Sr=fftshift(abs(fft(sr,Nfft)));

fplot=-Fs/2:Fs/Nfft:Fs/2-Fs/Nfft;

figure, plot(fplot,Sr)


[m, pos]=max(Sr);
frec=abs(fplot(pos))
vrec=(frec/f-1)*c






