clear all; 

load siren

% police siren frequency
f=1000;

% speed of sound
c=343; %m/s

% sampling frequency of the received signal
Fs=1e4;


% (a)

Nfft=2048;
Sr=fftshift(abs(fft(sr,Nfft)));

fplot=-Fs/2:Fs/Nfft:Fs/2-Fs/Nfft;

figure, plot(fplot,Sr), xlabel('Frequency [Hz]'), ylabel('Signal spectrum')

% The signal is a sinusoid with white noise.


% (b)

[m, pos]=max(Sr);
frec=abs(fplot(pos));

% The measured frequency is higher than f, therefore the policecar is
% getting closer to our driver (the police are faster)

% (c)

vrec=(frec/f-1)*c




