% MY_DEMOD Minimum distance slicer
% Z = MY_DEMOD(Y) demodulates vector Y
% by finding the element of the constellation [-1i,1, 1i, -1]that is
% closest to each element of input Y. 
% The elements of Z are integers between 0 and 3


function z = my_demod(y)

% For each element of y, we need to compute the distance to each symbol of the constellation, and
% find the one that is closest
% Make sure y is a vector
y=y(:).';


mapping=[-1i, 1, 1i, -1];
% Make sure mapping is a column vector
mapping = mapping(:);



% Compute all Euclidean distances
M = length(mapping); % size of the constellation
L = length(y);

distances = abs(repmat(y, M, 1) - repmat(mapping, 1, L));
   
% Another way to do this is to use meshgrid instead of repmat:


% distances is M x L, and column i contains the distance of received symbol i to all constellation points, i=1..L
% The slicer just needs to find the minimum of every column of this matrix
[mindistances, positions] = min(distances);
% Go from [1, 4] indices to [0, 3] symbols
z = positions - 1; 

