% Problem 3

close all
clear all

% Define parameters
N = 256; % number of carriers

% Load various files
load data_symbols.mat
load ofdm_rx_symbols.mat

% Plot to see the rotated Rx symbols
figure;
plot(ofdm_rx_symbols,'*'); grid on;
title('Rotated RX symbols');
xlabel('Real'); ylabel('Imag');

% Reshape into a matrix form
rx_fft = reshape(ofdm_rx_symbols, N, []);

% Plot the first OFDM block to check if the rotation is small enough indeed
figure;
plot(rx_fft(:,1),'*'); grid on;
title('First OFDM block');
xlabel('Real'); ylabel('Imag');

% Implement the decoding mechanism
decoded_symbols = zeros(size(rx_fft));
rot_col = 0;
rot_all_columns = zeros(1,size(rx_fft,2));
for i = 1:size(rx_fft,2)
   
    % Correct all the following columns with the previous rotation
    rx_fft = exp(-1j*rot_col)*rx_fft;
    
    % Get the current column
    col = rx_fft(:,i).';
 
    dec_symbols_col = (2*(real(col)>0) - 1) + 1j*(2*(imag(col)>0) - 1);
    % Compute the average rotation over all symbols in the block
    rot_col = mean(angle(col./dec_symbols_col));
    
    rot_all_columns(i) = rot_col;
    decoded_symbols(:,i) = dec_symbols_col;
    
end


% Plot the rotation just to check if constant over the blocks
figure;
plot(rot_all_columns,'*'); grid on;
title('Estimated rotation over all the OFDM blocks');
xlabel('OFDM block index'); ylabel('Angle [radians]');

% Serialize and compute SER
ds = decoded_symbols(:).';
SER = sum(ds(1:length(data_symbols)) ~= data_symbols)/length(data_symbols)
