import numpy as np
from scipy.linalg import toeplitz
import matplotlib.pyplot as plt
import scipy.io as sio

# Problem 2

# Define parameters
P = int(20)  # channel length

# Load various files
y_tmp = sio.loadmat('y.mat')
y = y_tmp['y'].flatten()

pn_seq = sio.loadmat('pn_sequence.mat')
pn_sequence = pn_seq['pn_sequence'].flatten()

# The actual channel (sample-level), for comparing with the estimated one
h = np.array([3.2, 1.7, 1.3, 1, 0.8, 0.45, 0.3, 0.15, 0.05])

# Create the Toeplitz matrix
first_column = np.concatenate((pn_sequence, np.zeros(P-1, dtype=np.complex)))
first_row = np.zeros(P, dtype=np.complex)
first_row[0] = pn_sequence[0]
S = toeplitz(first_column, first_row)
# Estimate (LS) the channel coefficients
tmp_matrix = np.matmul(S.conj().T, S)
tmp_vector = np.matmul(S.conj().T, y.T)
h_hat = np.linalg.lstsq(tmp_matrix, tmp_vector, rcond=None)[0]

# Plot to check if the estimated channel is correct
l1, = plt.plot(np.arange(0, h.size), h, 'ob')
l2, = plt.plot(np.arange(0, h_hat.size), h_hat.real, 'xr')
plt.grid()
plt.title('Channel impulse response')
plt.xlabel('Sample index')
plt.ylabel('Magnitude')
plot_lines = [l1, l2]
legend1 = plt.legend(plot_lines, ["Actual channel", "LS estimation"], loc=1)
plt.gca().add_artist(legend1)
plt.show()
