% Problem 2

close all
clear all

% Define parameters
P = 20; % channel length

% Load various files
load y.mat
load pn_sequence.mat

% The actual channel (sample-level), for comparing with the estimated one
h = [3.2, 1.7, 1.3, 1, 0.8, 0.45, 0.3, 0.15, 0.05];

% Create the Toeplitz matrix
first_column = [pn_sequence, zeros(1, P-1)];
first_row = [pn_sequence(1), zeros(1, P-1)];
S = toeplitz(first_column, first_row);
% Estimate (LS) the channel coefficients
h_hat = (S'*S)\(S'*y.');

% Plot to check if the estimated channel is correct
figure;
plot(1:1:length(h), h,'*'); grid on; hold on;
plot(1:1:length(h_hat), h_hat,'o');
title('Channel impulse response');
xlabel('Sample index'); ylabel('Magnitude');
legend('Actual channel', 'LS estimation');
