% Problem 3

close all; 
clear all;

% Load the various files
load('training_symbols.mat');
load('received_OFDM_symbols.mat');
load('lambdas.mat');


% Using the first column of the received symbols matrix and the training
% sequence, estimate the noise variance. The noise is assumed to have
% independent and identically distributed components.

noise_var = var(received_OFDM_symbols(:,1).' - training_symbols.*lambdas)


% If you do not manage to compute the noise variance, you can use a value
% of 0.01 for it in the following.

% Compute the LS estimate of the transmitted data symbols
D = diag(lambdas);
% Since D is diagonal, any of the following will work, they are the same.
data_LS_estim1 = received_OFDM_symbols(:,2:end)./(lambdas.');
data_LS_estim2 = pinv(D)*received_OFDM_symbols(:,2:end);
data_LS_estim3 = D\received_OFDM_symbols(:,2:end);


% Plot the estimated data symbols. You should get a noisy 4-QAM
% constellation.
suf_data = data_LS_estim1(:).';
figure; plot(suf_data, '*b'); xlabel('Re'); ylabel('Im'); grid on;
title('The constellation of the estimated data symbols (LS)');


% Compute the LMMSE estimate of the transmitted data symbols
D1 = D*D' + noise_var*eye(length(lambdas));
data_LMMSE_estim = D'*(D1\received_OFDM_symbols(:,2:end));


% Plot the estimated data symbols. You should get a noisy 4-QAM
% constellation.
suf_data = data_LMMSE_estim(:).';
figure; plot(suf_data, '*b'); xlabel('Re'); ylabel('Im'); grid on;
title('The constellation of the estimated data symbols (LMMSE)');


% Plot the absolute value squared of the lambdas. 
figure;
plot(abs(lambdas).^2,'-*b'); grid on;
xlabel('Frequency index'); ylabel('Magnitude');
title('|lambdas|^2');

% Then, compare the values of the estimated symbols obtained with the two
% methods above. For example, you can compare them by looking at the
% average difference between the two estimates. Explain your results (write
% your text in here).
average_difference_estimated_symbols = mean(abs(data_LS_estim1(:) - data_LMMSE_estim(:)))

% The two methods produce very similar estimates. This is due to the fact
% that the diagonal elements of D*D' (i.e., abs(lambdas).^2) are much
% larger than the noise variance, so the LMMSE formula simplifies to be the
% same as for LS.
