% Problem 2

close all; 
clear all;

% System parameters
num_carriers = 512;    % total number of carriers
prefix_length = 25;    % length of the cyclic prefix
num_ofdm_blocks = 1000; % number of OFDM blocks (1 will be used to transmit the training sequence and the rest is for data symbols)
SNR = 20; % in dB


% Generate the training symbols and the data symbols
% Both are drawn from a 4-QAM constellation with unit energy

training_real = 2*randi([0,1], 1, num_carriers) - 1;
training_imag = 2*randi([0,1], 1, num_carriers) - 1;
training_sequence = (1/sqrt(2))*(training_real + 1j*training_imag);

data_real = 2*randi([0,1], 1, num_carriers*(num_ofdm_blocks-1)) - 1;
data_imag = 2*randi([0,1], 1, num_carriers*(num_ofdm_blocks-1)) - 1;
data = (1/sqrt(2))*(data_real + 1j*data_imag);

% Generate the OFDM trasmitted signal

A = zeros(num_carriers, num_ofdm_blocks);
A(:,1) = training_sequence(:);
A(:,2:end) = reshape(data, num_carriers, []);

a0 = ifft(A, num_carriers);
a = [a0(num_carriers-prefix_length+1:num_carriers,:); a0];
tx_signal = a(:).';

% Pass the transmitted signal through the channel and add AWGN noise

% The discrete-time symbol-level channel impulse response, including the
% filters at the transmitter and the receiver, is the following:
h = [0.87, 0.62, -0.45, 0.34, -0.12];

% You should add AWGN such that we obtain an SNR = 20 dB with respect to
% the transmitted signal.


% Convolve tx_signal with the channel impulse response
rx_signal = conv(tx_signal, h);

% Add AWGN
E_tx = mean(abs(tx_signal).^2); % power of the transmitted signal (var(tx_signal))
sigma = 10^(-SNR/20) * sqrt(E_tx);
noise = sigma/sqrt(2)* (randn(size(rx_signal)) + 1i*randn(size(rx_signal)));
rx_signal_noisy = rx_signal + noise;


% Implement the OFDM receiver to obtain the noisy and scaled transmitted symbols

% Remove the tail
rx_signal_noisy = rx_signal_noisy(1:end-mod(length(rx_signal_noisy), prefix_length + num_carriers));

% Remove the cyclic prefix
rx_withCP = reshape(rx_signal_noisy, prefix_length + num_carriers, num_ofdm_blocks); 
rx_noCP = rx_withCP(prefix_length + (1:num_carriers), :); % remove the rows corresponding to cyclic prefix

% Go to the frequency domain
Rf = fft(rx_noCP, num_carriers);


% Estimate the channel coefficients (the lambdas) using the LS (Least
% Squares) estimator applied to the training sequence
lambda_estimated_LS = Rf(:,1).'./training_sequence;

% Compute the theoretical lambdas (using h)
lambda_theoretical = fft(h, num_carriers); % DFT of h

% Plot lambda_estimated_LS and lambda_theoretical to compare them
figure;
plot(abs(lambda_theoretical),'-*b'); hold on;
plot(abs(lambda_estimated_LS),'-+g');
xlabel('Frequency index'); ylabel('Magnitude'); title('The lambdas');
grid on; legend('Theoretical','LS Estimate');

% Equalize the received symbols (using lambda_theoretical)
eq_signal = Rf .* repmat(1./lambda_theoretical(:), 1, num_ofdm_blocks);
suf_statistics = eq_signal(:).';

% Plot the equalized received data symbols constellation
suf_data = suf_statistics(length(training_sequence) + 1:end);
figure; plot(suf_data, '*b'); xlabel('Re'); ylabel('Im'); title('Received constellation after OFDM demodulation and equalization');
hold on; plot(data, '+r'); grid on; legend('Received constellation', 'Transmitted constellation');

% Demodulate the received data symbols to obtain the estimates of the transmitted data symbols
estimated_data = (1/sqrt(2))*((2*(real(suf_data) > 0) - 1) + 1j*(2*(imag(suf_data) > 0) - 1));

% Compute the symbol error rate. If everything was correct, there should be no symbol errors.
SER = sum(estimated_data ~= data) / numel(data)
