import numpy as np
from numpy import linalg as LA
import matplotlib.pyplot as plt

# Problem 3

# Define parameters
N = 10 ** 4  # number of BPSK symbols
T = 1e-6  # symbol period
SPS = 5  # samples per symbol
SPAN = 20  # total length in symbols of the pulse shaping function
SNR_dB = 20  # dB
rng = np.random.default_rng()

# Generate N random BPSK symbols.
sk = 2 * rng.integers(2, size=N) - 1

# Create the samples of the pulse shaping function psi(t). Normalize it
# such that it has unit norm.

# compute the time line
M = SPAN * SPS
no_samples = M // 2
t = np.arange(-no_samples, no_samples + 1) / SPS
psi = np.sinc(t)

psi /= LA.norm(psi)  # normalize to have unit norm

# Plot the pulse shaping function generated above with the appropriate
# labelling of the time axis to check that you have got indeed the correct
# shape.

fig, ax = plt.subplots()
ax.plot(t * T, psi, '-o')
ax.set_xlabel('time [s]')
ax.set_ylabel('psi(t)')
ax.set_title('The pulse shaping function')
ax.grid()
fig.show()

# Create the samples of s(t).
sk_up = np.kron(sk, np.concatenate((np.ones(1), np.zeros(SPS-1))))
s = np.convolve(sk_up, psi)

# Describe in words the shape of h_F(f) (the Fourier transform of h(t)).

# h_F(f) = 1 for f in the interval [-1/(2T), 1/(2T)] and 0 otherwise.

# Convolve s with the channel h.

s_filtered = s  # nothing to do here, the channel is "transparent" to s

# Create the samples of N(t) such that the resulting SNR is 20 dB.

Es = np.var(sk)
# find the noise variance sigma2 so that 10*log_10(Es/sigma2) = SNR_dB
sigma2 = Es/(10 ** (SNR_dB/10))
sigma = np.sqrt(sigma2)
# create the sample-level noise vector
n = sigma * rng.normal(size=s_filtered.size)

# compute and print the SNR to check that it is indeed 20 dB
print('the_obtained_SNR_in_dB = ', 10 * np.log10(np.var(sk)/np.var(n)))

# Create the samples of R(t).

r = s_filtered + n

plt.show()

