% Problem 3

close all;
clear all;

% Define parameters
N = 1e4; % number of BPSK symbols
T = 1e-6; % symbol period
SPS = 5; % samples per symbol
SPAN = 20; % total length in symbols of the pulse shaping function
SNR_dB = 20; % dB


% Generate N random BPSK symbols.
sk = 2*randi([0, 1], 1, N) - 1;

% Create the samples of the pulse shaping function psi(t). Normalize it
% such that it has unit norm.

% compute the time line
M = SPAN * SPS;
no_samples = round(M/2);
t = (-no_samples : no_samples) / SPS;
psi = sinc(t);

psi = psi / norm(psi); % normalize to have unit norm

% Plot the pulse shaping function generated above with the appropriate
% labelling of the time axis to check that you have got indeed the correct
% shape.

figure;
plot(t * T, psi, '-o'); grid on;
xlabel('time [s]'); ylabel('psi(t)'); title('The pulse shaping function');

% Create the samples of s(t).
sk_up = upsample(sk, SPS);
s = conv(sk_up, psi);

% Describe in words the shape of h_F(f) (the Fourier transform of h(t)).

% h_F(f) = 1 for f in the interval [-1/(2T), 1/(2T)] and 0 otherwise.


% Convolve s with the channel h.

s_filtered = s; % nothing to do here, the channel is "transparent" to s


% Create the samples of N(t) such that the resulting SNR is 20 dB.

Es = var(sk);
% find the noise variance sigma2 so that 10*log_10(Es/sigma2) = SNR_dB
sigma2 = Es/(10^(SNR_dB/10));
sigma = sqrt(sigma2);
% create the sample-level noise vector
n = sigma * randn(size(s_filtered));

% compute and print the SNR to check that it is indeed 20 dB
the_obtained_SNR_in_dB = 10*log10(var(sk)/var(n))


% Create the samples of R(t).
r = s_filtered + n;



