function t=timeInterval(taus, ind1, B)
% TIMEINTERVAL Computes the time interval in which the satellite
% transmitted the signal between ind1 and the start of decoded bit number B
% TAUS: vector of indices into the received samples where each decoded bit begins
% IND1: (scalar) index into the vector of received samples showing the start of the analyzed interval



%check that ind1 and B > 0 
    if (ind1<=0 || B<=0)
         error('ind1 and B should be higher than zero');
    end

    
%check that ind1 <= taus(B) 
    if (ind1>taus(B))
         error('ind1 should be lower than taus(B)');
    end

    
%bit duration in seconds (at the satellite)
Tb=0.02;

%determine number of complete bits
    firstBitAfterInd1 = find(taus >= ind1, 1); % this is the bit number that starts at or after the sample tau_ref
    %bitAtInd2=find(taus==ind2);
    complete_bits = B - firstBitAfterInd1; % number of complete bits from the sample tau_ref til beginning of subframe

%determine fractional bits
    if (firstBitAfterInd1==1)  %avoid index zero
        firstBitAfterInd1=2;
    end
    
 fract_bits = (taus(firstBitAfterInd1) - ind1)/(taus(firstBitAfterInd1)-taus(firstBitAfterInd1-1));

t = Tb*(complete_bits+fract_bits);
