function E= iterateE(M, e, E_tolerance)

% CALCDELTATANDE Obtain the satellite clock offset and eccentric anomaly
% E = iterateE(M_0, e, E_tolerance)
% 
% M: Mean anomaly 
% e: Orbit ellipse eccentricity
% E_tolerance: stop when the difference between two consecutively
% determined values is lower than this parameter
%
% E: eccentric anomaly
   
%   To determine E, we need to iteratively solve E-e*sin(E)=M

  
Eold = M;
err = E_tolerance+1; %to be sure that there is at least one iteration
while (err >= E_tolerance)
    E = M + e * sin(Eold);
    err = abs(E-Eold);
    Eold = E;
end 
    
end 
