clear all;
close all;
clc;

num_carriers=16;
%num_zeros=2;
prefix_length=4;
num_symbols=9;
M_preamble = 4;        % we use 4-QAM for the preamble
M_data = 16;           % we use 16-QAM for the data
%channel_length=3;



load rx_signal 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% RX ofdm 


%determine # of OFDM symbols
num_sent_symbols=((length(rx_signal_noisy))/(num_carriers+prefix_length));

% "remove" cylic prefix:
rx_withCP = reshape(rx_signal_noisy, prefix_length+num_carriers, num_symbols); 
rx_noCP = rx_withCP(prefix_length+(1:num_carriers), :); % remove rows corresponding to cyclic prefix


% go to the frequency domain
Rf = fft(rx_noCP, num_carriers);

%channel equalization
Rf_eq = Rf .* repmat(1./D, 1, num_symbols); 

%remove unused carriers
Rf_eq(4,:)=[];
Rf_eq(5,:)=[];

% 
% %plot constelations for preamble, data
figure(1), subplot(1,2,1), plot(Rf_eq(:,1), '.b'), axis([-1.5 1.5 -1.5 1.5]), title('preamble constelation'), xlabel('I'), ylabel('Q'), grid;
figure(1), subplot(1,2,2), plot(Rf_eq(:,2:end), '.b'),title('data constelation'), xlabel('I'), ylabel('Q'), grid;


%determine data bits

%remove preamble
Rf_eq(:,1)=[];

%determine data bits
Rf_eq=Rf_eq(:);
Mdata=4;
constel_data = my_qammap(M_data);  %Mdata can be determined from the values of Rf
estim_data = my_demodulator(Rf_eq, constel_data); % returns decimal numbers in 0 .. length(constel_data) - 1
estim_bits=de2bi(estim_data, 4);
estim_bits=reshape(estim_bits',1,[]);


%convert data bits to text
text=native2unicode(bi2de(reshape(estim_bits, 8, [])'))';
disp(text)
