import ofdmc as ofdmc
import solutions.utilUSRP as utilUSRP
import numpy as np

"""
Tests the OFDM Transceiver using simulated channel
"""

# show info for debugging
ofdmc.verbose = True

if ofdmc.verbose:
    print(f'\nThe Doppler step is {ofdmc.fCorr} [Hz].\n')

# channel parameters
SNR = 20  # [dB]
CFO = 543  # [Hz] (carrier frequency offset)
ClkOffset = int(3)  # [samples] (sampling clock offset)

# generate new bits
data_bits = np.random.randint(2, size=ofdmc.nDataBits)
tx_signal = utilUSRP.transmitter(data_bits)

rx_signal = utilUSRP.channelSimulator(tx_signal, SNR, CFO, ClkOffset)

est_bits = utilUSRP.receiver(rx_signal)

# check if everything is correct.
print(f'{data_bits.size} bits transmitted, {np.sum(data_bits != est_bits)} bits decoded incorrectly, '
      f'BER = {np.sum(data_bits != est_bits)/data_bits.size}\n')
