import ofdmc as ofdmc
import utilSDR
import solutions.utilUSRP as utilBlocks
import numpy as np
import utilPDC

"""
Runs the OFDM Transceiver on a single machine (with one or more USRP boards)
"""

# show info for debugging
ofdmc.verbose = True

# transmit a text file:
filename = 'text.txt'
with open(filename) as file:
    text = file.read()

print('\nTransmitting the following text:')
print('--------------------------------')
print(text, '\n')

# convert the text to bits
txt = np.array([ord(c) for c in text])
data_bits = utilPDC.sol_de2bi(np.array([ord(c) for c in text]), 'right-msb', 8)
data_bits = data_bits.flatten('C')

n_tx_bits = data_bits.size

# randomization to ensure a balanced information sequence
np.random.seed(12345)
# data_bits = (data_bits + np.random.randint(2, size=data_bits.size)) % 2
# use this instead to generate the same random sequence as in Matlab
mask = (np.random.random((data_bits.size,)) > 0.5).astype(int)
data_bits = (data_bits + mask) % 2

tx_signal = utilBlocks.transmitter(data_bits)

rx_signal = utilSDR.runUSRPSinglePC(tx_signal, "TXRX")
# rx_signal = utilBlocks.usrpTxRx(tx_signal) # this is Matlab's legacy; in Python we have a slightly different approach
# rx_signal = utilBlocks.channelSimulator(tx_signal, 50, 543, 3)

est_bits = utilBlocks.receiver(rx_signal)

# remove the padded bits
est_bits = est_bits[:n_tx_bits]

# check if everything is correct.
print(f'{data_bits.size} bits transmitted, {np.sum(data_bits != est_bits)} bits decoded incorrectly, '
      f'BER = {np.sum(data_bits != est_bits) / data_bits.size}\n')

# undo randomization
np.random.seed(12345)
# est_bits = (est_bits + np.random.randint(2, size=est_bits.size)) % 2
# use this instead to generate the same random sequence as in Matlab
mask = (np.random.random((est_bits.size,)) > 0.5).astype(int)
est_bits = (est_bits + mask) % 2

rx_bits = np.reshape(est_bits, (-1, 8), order='C')
rx_chars = utilPDC.sol_bi2de(rx_bits, 'right-msb')
rx_text = ''.join(chr(i) for i in list(rx_chars.astype(int)))

print('\nReceived the following text:')
print('--------------------------------')
print(rx_text)
print('--------------------------------\n')
