import ofdmc as ofdmc
import utilSDR
import solutions.utilUSRP as utilBlocks
import numpy as np
import utilPDC

"""
Runs the OFDM Transceiver on the RX machine
"""

ofdmc.verbose = True

tx_signal = np.zeros(ofdmc.txSignalLength)

rx_signal = utilSDR.runUSRPSinglePC(tx_signal, "RX")

est_bits = utilBlocks.receiver(rx_signal)

# remove the padded bits
est_bits = est_bits[:ofdmc.nTextBits]

# undo randomization (see run_tx)
np.random.seed(12345)
# est_bits = (est_bits + np.random.randint(2, size=est_bits.size)) % 2
# use this instead to generate the same random sequence as in Matlab
mask = (np.random.random((est_bits.size,)) > 0.5).astype(int)
est_bits = (est_bits + mask) % 2

rx_bits = np.reshape(est_bits, (-1, 8), order='C')
rx_chars = utilPDC.sol_bi2de(rx_bits, 'right-msb')
rx_text = ''.join(chr(i) for i in list(rx_chars.astype(int)))

print('\nReceived the following text:')
print('--------------------------------')
print(rx_text)
print('--------------------------------\n')

print("Reception done!")
