function usrpConfig()
%USRPCONFIG Creates usrpc struct used by the USRP transceiver

global usrpc;

if ~isempty(usrpc)
    return;
end

% USRP parameters. Change with care, not to burn the boards!
usrpc.fc                 = 0.868e9; % [Hz] carrier frequency
usrpc.LOO                = 400e3;  % [Hz] local oscilator offset: to avoid any DC correction that is happening in the AD9364 (transceiver chip in USRP B200 mini)
usrpc.clockRateTx        = 5e6;    % [Hz] main clock
usrpc.interpolationTx    = 10;     % upsampling factors
usrpc.clockRateRx        = usrpc.clockRateTx; 
usrpc.decimationRx       = usrpc.interpolationTx;
usrpc.clockInputSource   = 'Internal';
usrpc.OutputDataTypeUSRP = 'double';
usrpc.samplesPerFrameRx  = 1e5;    % Max is 375000 in a burst.
usrpc.txRxDuration       = 2;      % [sec] (TX/RX on same PC)
usrpc.txDuration         = 100;   % [sec] (TX and RX on different PCs)
usrpc.rxDuration         = 5;      % [sec] (TX and RX on different PCs)
usrpc.gainTx             = 40;     % [dB] (range 0:0.25:89.75)
usrpc.gainRx             = 40;     % [dB] (range 0:1:76)

usrpc.Ts                 = usrpc.interpolationTx/usrpc.clockRateTx;

end