% Runs the OFDM Transceiver on the TX machine

clear all;
close all;

% load TX/RX settings
global ofdmc;
ofdmConfig();

% show info for debugging
ofdmc.verbose = 1;


% transmit a text file:
text = fileread('text.txt');

fprintf('Transmitting the following text:\n');
fprintf('--------------------------------\n');
fprintf('%s',text);

data_bits = sol_de2bi(uint8(text),'right-msb',8);
data_bits = reshape(transpose(data_bits),1,[]);
n_tx_bits = numel(data_bits);

% randomization to ensure a balanced information sequence
rng(12345);
% data_bits = mod(data_bits + randi([0 1], size(data_bits)), 2);
% use this instead to generate the same random sequence as in Python
data_bits = mod(data_bits + (rand(size(data_bits)) > 0.5), 2);

tx_signal = transmitter(data_bits);

usrpTx(tx_signal);