function tx_symbols = my_ofdm_tx_frame_with_pilots(num_carriers, psd_mask, prefix_length, training_symbols, pilot_indices, pilot_symbols, data_symbols)
%OFDM_TX_FRAME_WITH_PILOTS Generates an OFDM frame
%   TX_SYMBOLS = OFDM_TX_FRAME_WITH_PILOTS(NUM_CARRIERS, PSD_MASK, ...
%       PREFIX_LENGTH, TRAINING_SYMBOLS, PILOT_INDICES, PILOT_SYMBOLS, ...
%       DATA_SYMBOLS)
%
%       NUM_CARRIERS: number of carriers per OFDM block (power of 2) 
%       PSD_MASK: A {0,1}-valued vector of length NUM_CARRIERS, used to
%         turn off individual carriers.
%       PREFIX_LENGTH: cyclic-prefix length (in number of samples). 
%       TRAINING_SYMBOLS: vector of symbols known to the receiver, used
%         to estimate the channel. Its length is the number of ones in the
%         PSD_MASK (one training symbol per non-off carrier). 
%       PILOT_INDICES: indices of pilot symbols. 
%       PILOT_SYMBOLS: vector of pilot symbols.   
%       DATA_SYMBOLS: vector of symbols to transmit (it
%         will be padded with zeros if the number of data
%         symbols is not a multiple of the number of useful carriers, 
%         where the number of useful carriers is the number of ones 
%         in the PSD_MASK minus the number of pilot symbols).
%   TX_SYMBOLS: A column vector containing the generated OFDM symbols,
%   corresponding to one OFDM frame with the training symbols transmitted
%   during the first OFDM block and the data transmitted in the subsequent
%   OFDM blocks.
