function [tau_estim, cfo_estim] = my_estimateTauAndCFO(rx_symbols, preamble, T, cfo_range)
%ESTIMATETAUANDCFO estimates the starting time of the data symbols and the
%carrier frequency offset, by correlating the received signal with the preamble. 
%[TAU_ESTIM, CFO_ESTIM] = estimateTauAndCFO(RX_SYMBOLS, ...
%		PREAMBLE, T, CFO_RANGE)
%  
%   RX_SYMBOLS: the vector of received symbols.
%   PREAMBLE: the preamble sequence.  
%   T: the sampling period of data.
%   CFO_RANGE: vector of candidates CFO values, used to search for a 
%     coarse CFO estimate. The coarse estimate is then refined 
%     using a second order approximation.
%   TAU_ESTIM: the estimate of the starting time of the data symbols.
%   CFO_ESTIM: the estimate of the carrier frequency offset.

