import numpy as np
import matplotlib.pyplot as plt
import scipy.io
import utilPDC

# Load the samples, Fs and T from file
data = scipy.io.loadmat('mf_output.mat')
Fs, T = float(data["Fs"]), float(data["T"])

mfOutput = data["y"].flatten()  # flatten the array

# plot the eye diagram
utilPDC.sol_eyediagram(mfOutput, Fs, T)
plt.title('Eye Diagram')
plt.show()
