function sol_eyediagram(y, Fs, T)
%MY_EYEDIAGRAM Generates an eye diagram
%   MY_EYEDIAGRAM(Y, FS, T) plots the eye diagram corresponding to the
%   sampled matched filter output Y, assuming the sampling frequency is
%   Fs and the symbol duration is T

if (nargin < 3)
    T = 1;
end

if (~isscalar(Fs) || Fs < 0)
    error('Fs must be a positive scalar (sampling frequency)');
end

if (~isscalar(T) || T < 0)
    error('T must be a positive scalar (symbol duration)');
end

% make everything to column vectors
y    = y(:);
time = [0:1/Fs:2*T-1/Fs]'-T;
% remove extra samples (if any)
y    = y(1:length(y)-mod(length(y),length(time)));
y    = reshape(y,length(time),[]);

plot  (time,real(y)); % cast y to real, as it should be
xlabel('Time [s]');
ylabel('Amplitude');
grid  on;

end

