% basic script to plot the eye diagram

close all;
clear all;

nsymbols = 1e4; 
M = 4 % 4-ary qam
bitsPerSymb = log2(M);
nbits = nsymbols*bitsPerSymb;
beta = 0.22;
SPAN = 16;
T = 1; % s
SPS = 50;
Fs = SPS/T;
ch_delay = 0; % delay in multiples of Ts
SNR_dB = 20; % dB

% create the bits (0/1 values)
bits = randi(2,1,nbits) - 1;

% create the symbols (my_bi2de + my_qamMap + my_encoder)
MaryData = sol_bi2de(reshape(bits,nsymbols,bitsPerSymb));
% encode
map = sol_qamMap(M);
symbols = sol_encoder(MaryData,map);

% map symbols to samples (rcosdesign + my_symbols2samples)
h = rcosdesign(beta,SPAN,SPS);
% the pulse is already normalized
samples = sol_symbols2samples(symbols,h,SPS);

% noiseless channel with delay
samples = [zeros(ch_delay,1); samples]; % introduce the delay
Es = var(symbols);
% find the noise variance sigma2 so that 10*log_10(Es/sigma2) = SNR_dB
sigma2 = Es/(10^(SNR_dB/10));
sigma = sqrt(sigma2);
% create the sample-level noise vector
noise = (sigma/sqrt(2))*randn(size(samples)) + 1i*(sigma/sqrt(2))*randn(size(samples));
% the_SNR_in_dB_is = 10*log10(var(symbols)/var(noise)) % test that we get back SNR
% create the channel output
received = samples + noise;

% generate the sufficient statistics (my_sufficientStatistics)
[suffStat, mfOutput] = sol_sufficientStatistics(received,h,SPS);

% plot the eye diagram
figure;
sol_eyediagram(real(mfOutput), Fs, T); title('Eye Diagram - real component');
figure;
sol_eyediagram(imag(mfOutput), Fs, T); title('Eye Diagram - imag component');

% plot the received constellation (output of the MF)
figure;
plot(suffStat,'*'); grid on;
xlabel('Real'); ylabel('Imag'); title('Received constelation at the output of the MF');
