% basic script to plot the eye diagram

close all;
clear all;

nsymbols = 500 
M = 2 % BPSK
bitsPerSymb = log2(M);
nbits = nsymbols*bitsPerSymb;
beta = 0.9;
SPAN = 20;
R = 100; % symbols/s
Fs = 5000; % Hz

% derived parameters
SPS = Fs/R; % SPS = T/Ts
T = 1/R;

% create the bits (0/1 values)
bits = randi(2,1,nbits) - 1;

% create the symbols (my_bi2de + my_pskMap + my_encoder)
MaryData = sol_bi2de(reshape(bits,nsymbols,bitsPerSymb));
% encode
map = sol_pskMap(M);
symbols = sol_encoder(MaryData,map);

% map symbols to samples (rcosdesign + my_symbols2samples)
h = rcosdesign(beta,SPAN,SPS);
% the pulse is already normalized
samples = sol_symbols2samples(symbols,h,SPS);

% plot the RRC filter
sol_tfplot(h,Fs,'h',['RRC impulse response, \beta = ', num2str(beta), ', SPAN = ', num2str(SPAN)]);

% ideal impulse response and noiseless channel
received = samples;

% generate the sufficient statistics (my_sufficientStatistics)
[suffStat, mfOutput] = sol_sufficientStatistics(received,h,SPS);

% plot the eye diagram
figure; 
sol_eyediagram(mfOutput, Fs, T);

% plot the received constellation (output of the MF)
figure;
plot(suffStat,'*'); grid on;
xlabel('Real'); ylabel('Imag'); title('Received constelation at the output of the MF');
ylim([-1,1]); % to get a centered plot
