function tau_estim = sol_estimateTau(rx_signal, preamble)
%TAU_ESTIM = MY_ESTIMATE_TAU(RX_SIGNAL, PREAMBLE) 
%   Estimates the channel delay by computing the inner products between
%   the received signal (RX_SIGNAL) and the time-shifted copies of the 
%   known-to-receiver signal (PREAMBLE) and finding the maximizing 
%   time-shift.

if ~isvector(rx_signal) || ~isvector(preamble)
    error ('pdc:estimateTau', 'RX_SIGNAL and SYNC_CODE must be vectors');
end

% As explained in the documentation for xcorr, if the longest input vector
% of xcorr has length M, the output is a vector of length 2*M-1 with the
% element at position M corresponding to 'zero' time-shift between two
% inputs.

IP        = xcorr(rx_signal, preamble);

% plot the result of xcorr to check if there is a clear maximum
figure;
stem(abs(IP));
grid on; title('xcorr(rxSignal, preamble)');
xlabel('index'); ylabel('abs(xcorr)');

% remove zero padding and ramp-up, see documentation xcorr (tau_estim >= 0)
IP = IP(length(rx_signal):end);

[~, idx] = max(abs(IP));

tau_estim = idx - 1; % index 1 corresponds to 0 delay


% alternative way to get tau_estim
% M         = max(numel(rx_signal),numel(preamble));
% tau_range = [-M+1:M-1];
% [~, idx] = max(abs(IP));
% tau_estim = tau_range(idx);

end

