function [rx_signal, delay] = channel(samples, SNR_dB, Es, max_delay)
%CHANNEL Simulate AWGN channel with random propagation delay
% 

if ~isvector(samples)
    warning ('pdc:channel', 'TX_SIGNAL is not a vector, reshaping it!');
    samples = samples(:);
end

if nargin < 4
    max_delay = 50;
end

if ~isscalar(SNR_dB) || ~isreal(SNR_dB)
    error ('pdc:channel', 'SNR must be a real scalar');
end

if ~isscalar(Es) || ~isreal(Es) || (Es < 0)
    error ('pdc:channel', 'Symbol energy (Es) must be a real positive scalar');
end

% add the delay
delay = randi([0,max_delay]);
samples = [zeros(delay,1); samples];
% add the noise
% find the noise variance sigma2 so that 10*log_10(Es/sigma2) = SNR_dB
sigma2 = Es/(10^(SNR_dB/10));
sigma = sqrt(sigma2);
% create the sample-level noise vector
noise = (sigma/sqrt(2))*randn(size(samples)) + 1i*(sigma/sqrt(2))*randn(size(samples));
% the_SNR_in_dB_is = 10*log10(var(symbols)/var(noise)) % test that we get back SNR
% create the channel output
rx_signal = samples + noise;

end

