% Basic script to implement a full communication chain and determine the
% error probabilities

close all;
clear all;

nsymbols = 1e6 % use a smaller value while debugging
M = 4 % 4-ary qam
bitsPerSymb = log2(M);
nbits = nsymbols*bitsPerSymb;
beta = 0.22;
SPS = 4;
SPAN = 10;
SNR_dB = 10; % dB

% create the bits (0/1 values)
bits = randi(2,1,nbits) - 1;

% create the symbols (sol_bi2de, sol_qamMap, sol_encoder)
MaryData = sol_bi2de(reshape(bits,nsymbols,bitsPerSymb));
% encode
map = sol_qamMap(M);
symbols = sol_encoder(MaryData,map);

% map symbols to samples (rcosdesign + sol_symbols2samples)
h = rcosdesign(beta,SPAN,SPS);
% the pulse is already normalized
samples = sol_symbols2samples(symbols,h,SPS);

% add AWGN noise (complex valued! Determine the noise variance from the energy of the symbols and SNR_dB)
% % ========= pedestrian method ======
% find the signal energy per symbol
Es = var(symbols);
% find the noise variance sigma2 so that 10*log_10(Es/sigma2) = SNR_dB
sigma2 = Es/(10^(SNR_dB/10));
sigma = sqrt(sigma2);
% create the sample-level noise vector
noise = (sigma/sqrt(2))*randn(size(samples)) + 1i*(sigma/sqrt(2))*randn(size(samples));
% the_SNR_in_dB_is = 10*log10(var(symbols)/var(noise)) % test that we get back SNR
% create the channel output
received = samples + noise;
% % ========= end of pedestrian method ======

% % == alternative using awgn ==
% sigpower = 10*log10(Es);
% received = awgn(samples,SNR_dB,sigpower); % this is because the desired SNR_dB is with respect to the symbols not the samples
% % == end of alternative ==

% generate the sufficient statistics (sol_sufficientStatistics)
suffStat = sol_sufficientStatistics(received,h,SPS);

% plot the received symbols constellation
figure;
plot(suffStat,'*');
grid on; xlabel('Real'); ylabel('Imag');
title('The received symbols constellation');

% decode (sol_decoder)
MaryData_decoded = sol_decoder(suffStat,map);

% compute the symbol-error probability from simulation
symbolErrorCount = sum(MaryData(:) ~= MaryData_decoded(:));
symbolErrorProbability_simulated = symbolErrorCount/length(MaryData)

% compute the symbol-error probability from the formula
q = qfunc(sqrt(Es/sigma2));
symbolErrorProbability_formula = 2*q - q^2

% compute the bit-error probability from simulation (sol_de2bi)
bits_decoded = sol_de2bi(MaryData_decoded);
bitErrorCount = sum(bits_decoded(:) ~= bits(:));
bitErrorProbability_simulated = bitErrorCount/length(bits)

% compute the bit-error probability from the formula
bitErrorProbability_formula = q
