% Example of design of root-raised-cosine filter (RRC)

clear all;
close all;
%% Parameters
USF = 10;     % upsampling factor (number of samples per symbol)

% We need to truncate the infinite impulse response of the RRC filter 
% to approximate it by a FIR filter
span = 20;    % length of the truncated pulse is specified in terms of
              % the number of symbols 

beta = 0.5; % roll-off factor 
% change this to 0, 0.5 and 1.0 (for instance) and observe the effect on
% both the impulse and frequency response

%% Filter design

h = rcosdesign(beta, span, USF, 'sqrt'); % here the filter is already
                                           % normalized to norm 1
                                           
%fvtool(h, 'Analysis', 'impulse')   % Visualize the filter

%% Results

Fd = 1; % symbol rate
Fs = USF * Fd; % sampling frequency
sol_tfplot(h,Fs,'h',['RRC impulse response, \beta = ', num2str(beta)]);