function q = sol_rotate_z(p, phi)
%Q = ROTATE_Z(P, PHI) Rotate around z axis
%  This function rotates the point P (in some coordinate system) around
%  the z axis in the positive direction by an angle PHI [rad].
%
%  Both P and Q are _row vectors_ , PHI is a scalar

% Create rotation matrix
R = [ cos(phi) sin(phi) 0
     -sin(phi) cos(phi) 0
           0        0   1];

% Compute rotation and convert back to row vector
q = (R * p(:)).';

end % function rotate_z()
