function s = my_establishParity(ws)
%ESTABLISHPARITY Checks the parity of the GPS words 
%   S = ESTABLISHPARITY(WS) checks the parity of each word in the 
%   sequence of subframes WS and returns a possibly modified copy S of 
%   WS. The modification consists in flipping the first 24 bits of words 
%   for which the last bit of the previous word is 1. 
%   The last two bits of each subframe are 0 by convention. If the parity 
%   check fails, a warning is issued; otherwise a message indicating 
%   success is displayed. Both the input WS and the output S are 
%   binary (0 and 1) row vectors containing full subframes.


    % declare gpsc as global, and if it is not initialized, do it
    global gpsc;
    if isempty(gpsc)
        gpsConfig();
    end	

    % Parity check matrix (cf. GPS standard)
    H = [...
        1 0 1 0 1 0 % multiplies d1
        1 1 0 1 0 0 % multiplies d2 
        1 1 1 0 1 1 % ...
        0 1 1 1 0 0
        1 0 1 1 1 1
        1 1 0 1 1 1
        0 1 1 0 1 0
        0 0 1 1 0 1
        0 0 0 1 1 1
        1 0 0 0 1 1
        1 1 0 0 0 1
        1 1 1 0 0 0
        1 1 1 1 0 1
        1 1 1 1 1 0
        0 1 1 1 1 1
        0 0 1 1 1 0
        1 0 0 1 1 0
        1 1 0 0 1 0
        0 1 1 0 0 1
        1 0 1 1 0 0
        0 1 0 1 1 0
        0 0 1 0 1 1
        1 0 0 1 0 1
        0 1 0 0 1 1 % multiplies d24
        1 0 1 0 0 1 % multiplies D29*
        0 1 0 1 1 0 % multiplies D30*
        ];

    % Other needed parameters
    BPW = 30;             % Bits per word
    DBPW = 24;            % Databits per word

    % Check parameter validity
    nsf = length(ws) / gpsc.bpsf;
    if nsf ~= floor(nsf)
        error('WS must contain a multiple of subframes');
    end

    % Total number of words
    nw = nsf * gpsc.wpsf;

    % Flag to indicate whether parity check passed. Set this to false if you
    % detect a parity error somewhere. 
    passed = true;

    % COMPLETE THE ALGORITHM HERE
    % Note: For the first word of WS, you can assume that D29* and D30* are
    % zero. Reason: the last two bits of each subframe are 0 by convention.
    
    %...
    
    %...
    
    % Display a warning if there was an error
    if ~passed
        error('establishParity:unsuccessful', 'Parity check failed.');
    else
         fprintf(1, 'Parity check passed\n');
    end
